program define m_CBAR_PS
	version 9.1
	quietly set more off
	
/// MAKING THE PAIRS ///
	
local n1 = $n1
local n2 = $n2	
local name1 "$name1"
local name2 "$name2"
local montecarlo_pairs = 10^($accuracy/2)
matrix res_pair = J(`montecarlo_pairs',1,.) /// THIS MATRIX STORES THE RESULTS OF THE OUTER LOOP ///

display as txt "{hline}"
display as txt "{hilite}Computing"
display as txt "{hline}"
display as res "Each point corresponds to one iteration of the outer loop"
display as res "With this set of parameters, the computation requires {hilite:`montecarlo_pairs' iterations}"
display _newline(1)

	forvalues pair = 1(1)`montecarlo_pairs' {
		
		matrix mod_treatment1 = $name1
		
		if (`n1' == `n2') {
		}
		else if (`n1' > `n2') {
			
			local diff = `n1' - `n2'
			
			forvalues i = 1(1)`diff' {
				
				matrix which = matuniform(1,1)
				matrix which = ceil(which[1,1]*(`n1'-`i'+1))
				
				if (which[1,1] == 1) {
				matrix mod_treatment1 = mod_treatment1[2...,1]
				}
				else if (which[1,1] == (`n1'-`i'+1)) {
				matrix mod_treatment1 = mod_treatment1[1..(`n1'-`i'),1]
				}
				else {
				matrix mod_treatment1 = mod_treatment1[1..which[1,1]-1,1] \ mod_treatment1[which[1,1]+1...,1]
				}
			}
		}
		
		matrix data = (mod_treatment1,`name2')
		matrix truncated_data = data
		local n = rowsof(data)
		local floor = floor(`n'/2)
		local ceil = ceil(`n'/2)
		
		if (`floor' < `ceil') {
			
			matrix uneven = matuniform(1,1)
			matrix uneven = ceil(uneven[1,1]*`n')
			
			if (uneven[1,1] == 1) {
				matrix truncated_data = truncated_data[2...,.]
			}
			else if (uneven[1,1] == `n') {
			matrix truncated_data = truncated_data[1..`n'-1,.]
			}
			else {
			matrix truncated_data = truncated_data[1..uneven[1,1]-1,.] \ truncated_data[uneven[1,1]+1...,.]
			}
		}
		
		matrix mod_treatment1 = J(`floor',1,.)
		
		forvalues i = 1(1)`floor' {
			
			matrix which_pair = matuniform(1,1)
			matrix which_pair[1,1] = ceil(which_pair[1,1]*(2*`floor'-`i'+1))
			
			matrix mod_treatment1[`i',1] = truncated_data[which_pair[1,1],1]
			
			if (which_pair[1,1] == 1) {
			matrix truncated_data = truncated_data[2...,.]
			}
			else if (which_pair[1,1] == (2*`floor'-`i'+1)) {
			matrix truncated_data = truncated_data[1..(2*`floor'-`i'),.]
			}
			else {
			matrix truncated_data = truncated_data[1..which_pair[1,1]-1,.] \ truncated_data[which_pair[1,1]+1...,.]
			}
		}
		
		matrix mod_treatment2 = truncated_data[1..`floor',2]
		
		local n = rowsof(mod_treatment2)
		
		/// NORMALIZING THE VALUE OF THE TREATMENT SAMPLE ///
		
		forvalues i = 1(1)2 {
			matrix norm_treatment`i' = J(`n',1,.)
			
			forvalues j = 1(1)`n' {
				matrix norm_treatment`i'[`j',1] = (mod_treatment`i'[`j',1]-$low_int) / ($up_int-$low_int)
			}
		}
		
		matrix x = norm_treatment1
		
		
		/// MONTECARLO ///
		
		local montecarlo_shots = 10^($accuracy/2)
		local result = 0
		matrix res_shots = J(`montecarlo_shots',3,.) ///THIS MATRIX STORES THE RESULTS OF THE INNER LOOP ///
		
		forvalues shot = 1(1)`montecarlo_shots' {
			
			matrix x_reload = x
			matrix y_reload = norm_treatment2
			
			/// MAKING THE RANDOM PAIRS ///	
			
			matrix paired = J(`n',1,.)
			
			forvalues i = 1(1)`n' {
				matrix which_pair = matuniform(2,1)
				
				forvalues ii = 1(1)2 {
					matrix which_pair[`ii',1] = ceil(which_pair[`ii',1]*(`n'-`i'+1))
				}
				
				matrix paired[`i',1] = x_reload[which_pair[1,1],1] - y_reload[which_pair[2,1],1]
				
				if (`i' < `n') {
					
					if (which_pair[1,1]==1) {
					matrix x_reload = x_reload[2...,1]
					}
					else if (which_pair[1,1]==`n'-`i'+1) {
					matrix x_reload = x_reload[1..`n'-`i',1]
					}
					else if (1 < which_pair[1,1] < `n'-`i'+1) {
					matrix x_reload = x_reload[1..which_pair[1,1]-1,1] \ x_reload[which_pair[1,1]+1...,1]
					}
					
					if (which_pair[2,1]==1) {
					matrix y_reload = y_reload[2...,1]
					}
					else if (which_pair[2,1]==`n'-`i'+1) {
					matrix y_reload = y_reload[1..`n'-`i',1]
					}
					else if (1 < which_pair[2,1] < `n'-`i'+1) {
					matrix y_reload = y_reload[1..which_pair[2,1]-1,1] \ y_reload[which_pair[2,1]+1...,1]
					}
				 else {
				 matrix x_reload[1,1] = .
				 matrix y_reload[1,1] = .
				 }
				}
			}
			
			/// ASSIGNING VALUE TO THE RANDOM PAIRS ///
			
			matrix ps_result_x = J(`n',1,0)
			matrix ps_result_y = J(`n',1,0)
			
			forvalues i = 1(1)`n' {
				matrix flipping_coin = matuniform(1,1)
				
				if (paired[`i',1] > 0 & paired[`i',1] > flipping_coin[1,1]) {
				matrix ps_result_x[`i',1] = 1
				matrix ps_result_y[`i',1] = 0
				}
				else if (paired[`i',1] < 0 & -paired[`i',1] > flipping_coin[1,1]) {
				matrix ps_result_x[`i',1] = 0
				matrix ps_result_y[`i',1] = 1
				}
			}
			
			quietly svmat ps_result_x
			quietly svmat ps_result_y
			
			egen sum_x = sum(ps_result_x1)
			matrix sum_x = sum_x[1] 
			egen sum_y = sum(ps_result_y1)
			matrix sum_y = sum_y[1]
			
			if (sum_x[1,1] > sum_y[1,1]) {
			local result = `result' + (1 / `montecarlo_shots')
			}
			else if (sum_x[1,1] < sum_y[1,1]) {
			}
			else {
			local result = `result' + (.5 / `montecarlo_shots')
			}
			
			matrix res_shots[`shot',1] = sum_x[1,1]
			matrix res_shots[`shot',2] = sum_y[1,1]
			matrix res_shots[`shot',3] = `result'
			drop ps_result**
			drop sum**
			
		} /// ENDING INNER LOOP ///
		
		matrix res_pair[`pair',1] = res_shots[`montecarlo_shots',3]
		use temp2, clear
		noi di as txt "." _continue
		
		local end = `montecarlo_pairs'/25
		forvalues i = 1(1)`end' {
			if (`pair'==`i'*25) {
				disp "`pair'"
			}			
		}
		
	} /// ENDING OUTER LOOP ///

quietly svmat res_pair
generate prob_treat1 = sum(res_pair1) / `montecarlo_pairs'
matrix prob_treat1 = prob_treat1[_N]
	
display _newline(1)
display as txt "{hline}"
display as txt _col(50) "{hilite}RESULTS"
display as txt "{hline}"
display _newline(1)
display as txt "{hline}"
display as txt "{hilite}PARAMETERS"
display as txt "{hline}"
display as txt "Regret:" as res _col(17) regret[1,1] /*
*/as txt _col(70) "Cost for Treatment1:" as res _col(80) " $cost1"
display _newline(1)
display as txt "Method:" as res _col(17)" Correlated Binomial Average Rule" /*
*/as txt _col(70) "Cost for Treatment2:" as res _col(80) " $cost2"
display _newline(1)
display as txt "Paired sample:" as res _col(17) " Yes"
display _newline(1)
display as txt "Range of values:" as res _col(17) "[$low ; $up]"

local prob_treat1 = prob_treat1[1,1]
local prob_treat2 = 1 - prob_treat1[1,1]

display _newline(1)
display as txt "{hline}"
display as txt "{hilite}RECOMMENDATION"
display as txt "{hline}"
display _newline(1)
display as txt "Probability of choosing {hilite:Treatment 1}:" as res " 0"`prob_treat1'
display _newline(1)	
display as txt "Probability of choosing {hilite:Treatment 2}:" as res " 0"`prob_treat2'
	
end
